// ************
// DOME2DtoGRID
// ************
// places 2D image along grid lines of dome master
// (C) 2017 VIOSO GmbH info@vioso.com

//$ SingleTexture


//$	AddressU	Border
//$	AddressV	Border
//$	FilterMag	Linear
//$	FilterMin	Linear
//$	FilterMip	Linear

//$ Comment
//$	VarsBegin		Name						Min		Max			Default		Expression
//$ Vars 6
//$	Var1 TimerM Azimuth	-180.00	180.00 0.0	
//$	Var2 TimerM Elevation	0.00 90.00 55.0 
//$	Var3 TimerM FOV	0 90.00 45 
//$	Var4 TimerM Ratio[w/h*100]	0 1790.00 178 val/100.0
//$	Var5 TimerM	Mirror	0 1 1 
//$	Var6 TimerM	Flip	0 1 0 
//$	VarsEnd 

static const float c_PI   =3.141592653589793238462643383279502884197169399375105820974944592308;
static const float c_PIH  =c_PI/2.0;
static const float c_2PI  =2.0*c_PI;
static const float c_G2R  =c_PI/180.0;
static const float c_G2RH =c_G2R/2.0;
static const float4 c_BgColor= float4( 0, 0, 0, 0);

float4 ps_col_2DtoDome (float4 co : r_COLOR, float2 pos : r_TEXCOORD) : r_COLOR
{
	float4 vA;
	float f,u,v;
	float2 vPos=float2( 2.0*(pos.x - 0.5), 2.0*(pos.y - 0.5) );
	float d=length(vPos);
	float4 vT=var0;//float4( 0.0, 45.0, 90.0, 4.0 );	// var0;//
	
	//texContent.GetDimensions( u, v);
	//float2 texs = d;
	//vT.w=texs.x/texs.y;
	//vT.w = 1.7777777;
	
	f=fmod( vT.x + 180.0, 360.0);
	vT.x=(f<0.0)? f + 180.0 : f - 180.0;
	
	f=atan2( vPos.y, vPos.x )/c_PI;
	u=(1.0 + f)/2.0;
	v=d;

	vA.zw=float2( vT.w*vT.z/360.0, vT.z/90.0);
	vA.xy=float2( (1.0 + vT.x/180.0 - vA.z)/2.0, vT.y/90.0 - vA.w/2.0 );
	
	f=( u - vA.x )/vA.z;
	v=( v - vA.y )/vA.w;
	if(f<0.0)
		f=( 1.0 + u - vA.x )/vA.z;
	else if(f>=1.0)
		f=( u - 1.0 - vA.x )/vA.z;
			
	float2 texco = float2 (f,v);	
	
	if (var1.x==1.0){	
	texco.y = 1-texco.y;
	}
	
	if (var1.y==1.0){	
	texco = 1-texco;
	}
	
	return ( (d>1.0) || (f<0) || (f>=1) || (v<0) || (v>=1) )? c_BgColor : tex2D( tex,texco); 
}

pixelfragment PIXEL_FRAGMENT_NAME = compile_fragment FX_PS_VER ps_col_2DtoDome ();
