// ****************
// DOMEPANOTOSPHERE
// ****************
// wraps equirectangular panorama image on dome
// (C) 2017 VIOSO GmbH info@vioso.com

//$ SingleTexture

//$	AddressU		Clamp
//$	AddressV		Clamp
//$	FilterMag	Linear
//$	FilterMin	Linear
//$	FilterMip	Linear

//$ Comment
//$	VarsBegin		Name						Min		Max			Default		Expression
//$ Vars 10
//$	Var1 TimerM Azimuth	-180.00	180.00 90.0	
//$	Var2 TimerM Elevation	-180.00 180.00 75.0 
//$	VarsEnd 

static const float c_PI   =3.141592653589793238462643383279502884197169399375105820974944592308;
static const float c_PIH  =c_PI/2.0;
static const float c_2PI  =2.0*c_PI;
static const float c_G2R  =c_PI/180.0;
static const float c_G2RH =c_G2R/2.0;
 
uniform float4 winkel= { 180, 90, 30, 60 };

//float3 dark_color  = float3 (0.20f, 0.05f, 0.00f);


float4 ps_mod_equirect2dome (float4 co : r_COLOR, float2 pos : r_TEXCOORD) : r_COLOR
{

winkel.x = var0.x;
winkel.y = var0.y;   
	float3 v3D,vTmp;
	float2 v2D;
	float  c,s,l;
	
	v2D.x=( 2.0*pos.x - 1.0 );
	v2D.y=( 1.0 - 2.0*pos.y );
	
	l= v2D.x*v2D.x + v2D.y*v2D.y;
	
	v3D.x=v2D.x;
	v3D.y=v2D.y;
	v3D.z=sqrt( 1.0 - l );
	l=winkel.x*c_G2R;
	c=cos(l);
	s=sin(l);
	vTmp.x= c*v3D.x - s*v3D.y;
	vTmp.y= s*v3D.x + c*v3D.y;
	vTmp.z=v3D.z;

	l=winkel.y*c_G2R;
	c=cos(l);
	s=sin(l);
	v3D.x= c*vTmp.x + s*vTmp.z;
	v3D.y= vTmp.y;
	v3D.z=-s*vTmp.x + c*vTmp.z;
	
	v2D.x=atan2( v3D.y, v3D.x );
	v2D.y=atan( v3D.z/length(v3D.xy) );
		
	return tex2D( tex, float2( 0.5 + v2D.x/c_2PI, 0.5 - v2D.y/c_PI));
}

pixelfragment PIXEL_FRAGMENT_NAME = compile_fragment FX_PS_VER ps_mod_equirect2dome ();
