# Domeprojection Genesis IG Plugin

The domeprojection Genesis IG Plugin allows to apply static warping and blending in Genesis IG.

Tested on  Genesis IG v2.6.0.1

## Installation

1. Copy the domeprojection folder into the genesis plugins folder.
2. Edit the config/plugin_config.xml and add an entry for the dpGenesisIGPlugin (example is provided in this archive)
3. Install CodeMeterRuntime 

```xml
...
<plugin_cfg enabled="true" plugin_bin="dpGenesisIGPlugin.dll" plugin_config_file="%DVC_GIG_ROOT%/plugins/x64/domeprojection/dpGenesisIGPlugin.def">
</plugin_cfg>
...
```

## Configuration

* The warp folder contains an example configuration set that can be used for testing.
* The warp and blend files to be used are configured inside dpGenesisIGPlugin.def

```xml
<?xml version="1.0" encoding="utf-8"?>
<image_processor>
  <buffer use_32_bit_float_depth="1" />
  <view_data id="0" warp="c:/domeprojection/warp/warpmap_0.csv" blend="c:/domeprojection/warp/shading_0.png"/>
  <view_data id="1" warp="c:/domeprojection/warp/warpmap_1.csv" blend="c:/domeprojection/warp/shading_1.png"/>
  <view_data id="2" warp="c:/domeprojection/warp/warpmap_2.csv" blend="c:/domeprojection/warp/shading_2.png"/>
</image_processor>
```

* Correction data can be exported using Mapper3D domeprojection SDK exporter.
* Setup the frustum and eye_offset settings in config/window_definition.xml matching the settings in Mapper3d.

## Licensing ## 

dpGenesisIGPlugin requires licenses. Without valid licenses, a watermark is shown on top of the display output. For each active display one channel license is required.

The licenses are stored on a hardware dongle from CodeMeter. For this dongle to work the CodeMeter runtime must be installed on each PC using the plugin.

The license can optionally be distributed over local network. For example in a render cluster only one PC with a licensing dongle and enough channel licenses is required.

### Server settings ###

Network based licensing must be activated on the computer with the dongle attached to. To enable the license server you will need to open Codemeter WebAdmin. There are several ways of doing this, such as right-clicking on the Codemeter app icon in the app tray and selecting the option to open WebAdmin. Once in WebAdmin navigate to *Configuration -> Server -> Server Access* and enable the network server. 

![Server access](Images/codemeterServerAccess.png)

    Figure 7: Server Access settings in CodeMeter WebAdmin 

Apply the changes and restart the Codemeter runtime (right-click the icon, select "Exit", and restart the program) in order to activate the server.

### Client settings ###

DPPrepar3D plugin usually gets the license from the sever through a broadcast mechanism. Additionally (or in case of network issues), the location of the license server can be configured on each PC running the plugin. Open WebAdmin as described above and navigate to *Configuration -> Basic -> Server Search List*. Add the IP-address of the License Server to the Server Search List. __Note__: Internet Explorer, which may be used by default, will need a security exception to allow the input dialogue. There will be a notification if it's needed.

![Server search](Images/codemeterServerSearch.png)

    Figure 8: server search settings in CodeMeter WebAdmin

__Note__: after starting the plugin it may take a few seconds until the license is found. The license is checked periodically by the plugin and the watermark will disappear once it is found. Please check your network and firewall settings if the watermark does not disappear after a minute or so. The web configuration of CodeMeter may not work with older browsers, for example Internet Explorer in Windows 7. In this case use the following command line in a terminal instead: *C:nProgram Files (x86)nCodeMeternRuntimenbinn"cmu32.exe --add-server SERVER-IP*.
