
#pragma once
/******************************************************************************
*
* Author: Asim Goheer
*
* DebugLogger will allow you to write logs to local folder in 
* Windows Runtime C++ projects.
*
* This class will allow you to log everything to isolated storage(or local folder). Once all the 
* logging is done it will do proper clean-up and release the file.
* 
******************************************************************************/

#include <Windows.h>
#include <time.h>
#include <stdio.h>

class Logger
{
public:
	Logger( const std::string &file );
	virtual ~Logger();

	void WriteLine( const char *msg );
	void Write( const char *fmt, ... );

private:
	void Init();
	void GetCurrentDateTime( char* buffer, int size );

private:
	CRITICAL_SECTION  m_critSec;
	FILE *m_pFile;
};
