# DPUnrealPlugin and Sample Data Documentation #

## Prerequisites ##

* DirectX 11
* Windows 64-bit

and either:

* Unreal Engine 4.26 with nDisplay plugin enabled

or 

* Unreal Engine 4.27 with nDisplay and Switchboard plugins enabled

## About this documentation ##

This documentation is intended to provide a guide for how to use the attached sample data set in Unreal Engine 4.26 and 4.27, as well as some general setup tips for using the domeprojection.com plugin that comes included with these versions of Unreal Engine.

## About the sample data set ##

The sample data set is exported from Mapper3D, which is part of the domeprojection.com ProjectionTools suite, for the domeprojectionSDK that powers the plugin included with Unreal Engine. It describes a 3-channel cylinder setup and has three different data sets representing three different kinds of correction data: static warping, dynamic warping, and dynamic warping with directional shading.

Each data set has two accompanying nDisplay configuration files - one for use with Unreal Engine 4.26 (.cfg extension) and one for use with 4.27 (.uasset extension). These have been pre-prepared by us for demonstrating the correction data. The viewports in the configuration files are small (640 x 480) so that all three channels can be viewed conveniently on one monitor. 

The data set is designed to be used with the nDisplay template project in Unreal Engine. Once you have set up a new project using the template it is recommended to copy the sample data set and configuration files into the project's "Content" folder for convenience.

## Note about file locations ##

Both engine versions and their accompanying plugins allow you to start the compiled application (in this case the nDisplay template project compiled in the engine by navigating to File -> Package Project-> Windows 64-bit) on a different PC than you run it from, as both use a launcher application to signal the start of the application and a listener application to run it, which can be placed on different PCs. If you are doing this then you must have a copy of both the compiled application and the correction data set on the image generator PC. Adjust the IP addresses and file paths in the configuration files if using 4.26, or in Switchboard if using 4.27, accordingly to fit the locations of these files on the image generator PC (see nDisplay section in Unreal documentation for instructions on this [nDisplay in 4.26](https://docs.unrealengine.com/4.26/en-US/WorkingWithMedia/nDisplay/Overview/), [nDisplay in 4.27](https://docs.unrealengine.com/4.27/en-US/WorkingWithMedia/IntegratingMedia/nDisplay/Overview/)).

## Applying the data in 4.26 ##

1. Open the nDisplay Launcher on the control PC and the nDisplay Listener on the image generator PC (both of these applications can be found in *EngineDirectory*/Engine/Binaries/DotNET and can be copied and run in another location if desired). 
2. Provide the nDisplay Launcher with the locations of the complied executable and the configuration file for the correction data set you would like to see.
3. Click "Run" (with the executable highlighted).

## Applying the data in 4.27 ##

Unlike engine version 4.26, in 4.27 the configuration files will not accept a relative path to the config.xml in the correction data set exported from Mapper3D. To set the complete path to this file:

1. Double-click on the configuration in the content browser in the editor window to open the 3D config editor. 
2. In the cluster window in the bottom-left of the 3D config editor you can select viewports and in the details tab provide the complete path to the config.xml on the image generator PC. 
3. Save the changes to ensure they take effect.

To run the application with the correction data applied:

1. Open Switchboard on the control PC and Switchboard Listener on the image generator PC. Both can be run from the toolbar of the engine editor. Switchboard Listener can also be found in *EngineDirectory*/Engine/Binaries/Win64 and can be copied and run independently of the engine; Switchboard can be also run from a batch script in *EngineDirectory*/Engine/Plugins/VirtualProduction/Switchboard/Source/Switchboard which allows you run it without opening the engine, but it cannot be copied out of its location in the engine and run.
2. In Switchboard add an nDisplay device and open one of the configuration files
3. Set the IP address if running the application on another PC 
3. Go into the settings and ensure that either the path to the .uproject file is set if you'd like to run in that mode (only available if control PC and image generator PC are the same), or the path the the executable is set and the project file field is empty if you are running from a compiled executable. 
4. Change the render API from DirectX 12 to DirectX 11. You can now connect to the listener and launch the application with the correction data applied. 

## Configuration considerations in 4.27 ## 

* In all correction types the origin which can be set for each view point in the 3D config editor is ignored
* For the static correction type the view point is calculated by adding the view point in the exported data set to the player start position in the scene, and the "Default View Point" in the engine configuration is ignored. For the dynamic correction types the eyepoint is calculated by adding the "Default View Point" to the player start position.

## How to update the domeprojectionSDK in your Unreal Engine installation ##

Please contact us to get a copy of the latest domeprojectionSDK. Once you have the files copy the "dplib.dll" and "WibuCm64.dll" from inside the "bin" folder and paste them into *EngineDirectory*\Engine\Plugins\Runtime\nDisplay\ThirdParty\Domeprojection\DLL, replacing the files that are in there.