// *************
// DOME2DTOSHAPE
// *************
// places 2D image as pseudo 3D layer in dome
// (C) 2017 VIOSO GmbH info@vioso.com


//$ SingleTexture
//$	AddressU		Border
//$	AddressV		Border
//$	FilterMag	Linear
//$	FilterMin	Linear
//$	FilterMip	Linear

//$ Comment
//$	VarsBegin		Name						Min		Max			Default		Expression
//$ Vars 4
//$	Var1 TimerM Azimuth	-180.00	180.00 0.0	
//$	Var2 TimerM Elevation	0.00 90.00 55.0 
//$	Var3 TimerM FOV	0 90.00 45 
//$	Var4 TimerM Ratio[w/h*100]	0 1000.00 178 val/100.0
//$	VarsEnd 

static const float c_PI   =3.141592653589793238462643383279502884197169399375105820974944592308;
static const float c_PIH  =c_PI/2.0;
static const float c_2PI  =2.0*c_PI;
static const float c_G2R  =c_PI/180.0;
static const float c_G2RH =c_G2R/2.0;
static const float4 c_BgColor= float4( 0, 0, 0, 0);


float2 DomeMasterUV(float4 vT,float2 vPos,float d)
{
	float4 vA;
	float f,u,v;

	f=fmod( vT.x + 180.0, 360.0);
	vT.x=(f<0.0)? f + 180.0 : f - 180.0;
	
	f=atan2( vPos.y, vPos.x )/c_PI;
	u=(1.0 + f)/2.0;
	v=(var1.x>0.5)? ( c_PIH - acos(d) )/c_PIH : d;

	vA.zw=float2( vT.w*vT.z/360.0, vT.z/90.0);
	vA.xy=float2( (1.0 + vT.x/180.0 - vA.z)/2.0, vT.y/90.0 - vA.w/2.0 );
	
	f=( u - vA.x )/vA.z;
	v=( v - vA.y )/vA.w;
	if(f<0.0)
		f=( 1.0 + u - vA.x )/vA.z;
	else if(f>=1.0)
		f=( u - 1.0 - vA.x )/vA.z;
		
	return float2( f, v);
}

float4 ps_mod_dome_16x9toD (float4 co : r_COLOR, float2 pos : r_TEXCOORD) : r_COLOR
{
	float2 vR,vP,vO,vDM;
	float u,v,c,s,sX,sY,r;
	float2 vPos=float2( 2.0*(pos.x - 0.5), 2.0*(pos.y - 0.5) );
	float d=length(vPos);

	//vO=float2( 0.5, 0.5 );
	
	//sX=-1.0;
	//sY= 0.5;
	
	//texContent.GetDimensions( u, v);
	r= var0.w;

	u=sin(var0.y*c_G2R);
	sY=var0.z/90.0;
	sX=-sY*r;
	vO.x=u - sY/2.0;
	vO.y=-sX/2.0;
	
	c=cos(-var0.x*c_G2R);
	s=sin(-var0.x*c_G2R);
	vP.x=c*vPos.x - s*vPos.y;
	vP.y=s*vPos.x + c*vPos.y;
	
	vDM=DomeMasterUV( float4( 0, var0.y, var0.z, r), vP, d);

	vR=vP-vO;
	u=vR.y/sX;
	v=vR.x/sY;
	
	v=(1.0 - vP.x)*v + vP.x*vDM.y;
	
	return ( (d>1) || (u<0) || (u>=1) || (v<0) || (v>=1) )? (var1.y>0.5)? tex2D( tex, pos) : c_BgColor : tex2D( tex, float2( u, v) );
} 

pixelfragment PIXEL_FRAGMENT_NAME = compile_fragment FX_PS_VER ps_mod_dome_16x9toD();
