///
/// Copyright (C) 2018 domeprojection.com GmbH.
/// All rights reserved.
/// Contact: domeprojection.com GmbH (support@domeprojection.com)
///
/// This file is part of the dpLib.
///

#ifndef _DPUTILS_H_
#define _DPUTILS_H_

#include "dpDllspec.h"
#include "dpTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

DPLIB_API dpResult dpGetErrorMessageString(long error, char* buffer, size_t size);

DPLIB_API dpResult dpLoadTargetRectFromFile(const char* filename, dpTargetRect* pRect);

DPLIB_API dpResult dpLoadScreenShapeFromFile(const char* filename, dpMesh* pMesh, bool flip = false);

DPLIB_API dpResult dpLoadWarpmapFromFile(const char* filename, dpMesh* pMesh, bool flipVertices = false, bool flipUvs = false);
DPLIB_API dpResult dpCreateQuad(dpMesh* pMesh, float width = 1.f, float height = 1.f, bool flipVertices = false, bool flipUvs = false);

DPLIB_API dpResult dpLoadCameraFromFile(const char* filename, dpCamera* pCamera);

DPLIB_API dpResult dpGetDirAndUp(const dpVec3f orientation, dpVec3f* pDir, dpVec3f* pUp);
DPLIB_API dpResult dpGetOrientation(const dpVec3f dir, const dpVec3f up, dpVec3f* pOrientation);

DPLIB_API dpResult dpGetOrthoMatrix(dpMatrix4x4* pOrtho, float left, float right, float bootom, float top, float zNear, float zFar);
DPLIB_API dpResult dpGetProjectionMatrix(const dpCamera camera, dpMatrix4x4* pProjection);
DPLIB_API dpResult dpGetModelViewMatrix(const dpCamera camera, dpMatrix4x4* pModelView);
DPLIB_API dpResult dpGetOffAxisViewPortal(const dpVec3f position, const dpVec3f topLeft, const dpVec3f bottomLeft, const dpVec3f bottomRight, dpCamera* pCamera);
DPLIB_API dpResult dpGetModelViewProjectionMatrix(const dpCamera camera, dpMatrix4x4* mvp);
DPLIB_API dpResult dpGetWorldToScreen(const dpCamera camera, dpVec3f world, dpVec2f* pScreen);
DPLIB_API dpResult dpGetTransposedMatrix(const dpMatrix4x4& matrix, dpMatrix4x4* transposed);

DPLIB_API dpResult dpSaveObj(const char* filename, const dpMesh &mesh);

DPLIB_API dpResult dpGetCurrentDirectory(char* buffer, size_t size);
DPLIB_API dpResult dpGetDirectoryName(const char* path, char* buffer, size_t size);
DPLIB_API dpResult dpIsPathRooted(const char* path, bool* rooted);
DPLIB_API dpResult dpGetFullPath(const char* path, char* buffer, size_t size);

DPLIB_API dpResult dpGetChannels(dpContext* pContext, unsigned int* pChannels, size_t* pSize);
DPLIB_API dpResult dpGetCamera(dpContext* pContext, unsigned int channel, dpCamera* pCamera);

DPLIB_API dpResult dpDumpContext(const char* filename, dpContext* pContext);

DPLIB_API dpResult dpGetConfigurationFileNames(dpContext* pContext, unsigned int channel, char** ppFilenames, size_t* pSize);

#ifdef __cplusplus

float dpClamp(float value, float min, float max);
float dpMax(float value, float max);
float dpMin(float value, float min);

dpResult dpLoadConfigurationFromFile(dpContext* pContext, const char* filename);
}
#endif

#endif // _DPUTILS_H_
