//includethebasicwindowsheaderfilesandtheDirect3Dheaderfile
#include <windows.h>
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#include <windowsx.h>
#include <d3d9.h>
#include <d3dx9tex.h>
#include <d3dx9math.h>
#include <algorithm>
#include <string>
#include <filesystem>
#include <memory>

#include "dpLib.h"
#include "dpUtils.h"

//globaldeclarations
LPDIRECT3D9 d3d; //thepointertoourDirect3Dinterface
LPDIRECT3DDEVICE9 d3ddev; //thepointertothedeviceclass
LPDIRECT3DVERTEXBUFFER9 v_buffer = NULL; //thepointertothevertexbuffer
dpContext* CTX = NULL;
LPDIRECT3DTEXTURE9 skyboxtex[6];
LPD3DXFONT font = NULL;

dpVec3f POSITION;

float g_fWarping = 1.f;
float g_fBlending = 1.f;
float g_fBlackLevel = 1.f;

//functionprototypes
bool initD3D(HWND hWnd); //setsupandinitializesDirect3D
void render_frame(void); //rendersasingleframe
void cleanD3D(void); //closesDirect3Dandreleasesmemory
bool init_graphics( HWND hWnd ); //3Ddeclarations
void render_skybox(float heading, float pitch, float bank); // renders a skybox
bool DrawMessage(LPD3DXFONT font, unsigned int x, unsigned int y, int alpha, unsigned char r, unsigned char g, unsigned char b, LPCSTR Message);

struct CUSTOMVERTEX { FLOAT X, Y, Z; DWORD COLOR; };
#define CUSTOMFVF (D3DFVF_XYZ | D3DFVF_DIFFUSE)

struct SKYBOXVERTEX { FLOAT X, Y, Z; FLOAT U, V; };
#define SKYBOXFVF (D3DFVF_XYZ | D3DFVF_TEX1)

int g_windowPosX = 0;
int g_windowPosY = 0;
int g_windowWidth = 1000;
int g_windowHeight = 1000;
wchar_t g_configfile[260] = L"data\\config.xml";

//theWindowProcfunctionprototype
LRESULT CALLBACK WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);


//theentrypointforanyWindowsprogram
int WINAPI wmain(int nArgs, wchar_t const* szArglist[] )
{
	int i;

	if (NULL != szArglist)
	{
		for (i = 1; i < nArgs; i++)
		{
			std::wstring p(szArglist[i]);
			if (p[0] == '-')
			{
				std::wstring param = p.substr(1, std::wstring::npos);
				if (param == L"x" && i < nArgs - 1)
				{
					g_windowPosX = _wtoi(szArglist[i + 1]);
					i++;
				}
				if (param == L"y" && i < nArgs - 1)
				{
					g_windowPosY = _wtoi(szArglist[i + 1]);
					i++;
				}
				if (param == L"w" && i < nArgs - 1)
				{
					g_windowWidth = _wtoi(szArglist[i + 1]);
					i++;
				}
				if (param == L"h" && i < nArgs - 1)
				{
					g_windowHeight = _wtoi(szArglist[i + 1]);
					i++;
				}
				if (param == L"c" && i < nArgs - 1)
				{
					wcscpy_s( g_configfile, 260, szArglist[i + 1] );
					i++;
				}
			}
			else
			{
				wcscpy_s( g_configfile, 260, szArglist[i] );
			}
		}
	}

	HWND hWnd;
	WNDCLASSEX wc;

	ZeroMemory(&wc, sizeof(WNDCLASSEX));
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = WindowProc;
	wc.hInstance = ::GetModuleHandle( nullptr );
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.lpszClassName = L"WindowClass";

	RegisterClassEx(&wc);

	hWnd = CreateWindowEx(WS_EX_APPWINDOW | WS_EX_WINDOWEDGE,
		L"WindowClass",
		L"dpLib demo renderer",
		WS_OVERLAPPEDWINDOW,
		g_windowPosX, g_windowPosY,
		g_windowWidth, g_windowHeight,
		NULL,
		NULL,
		wc.hInstance,
		NULL);

	DWORD dwStyle = GetWindowLong(hWnd, GWL_STYLE);
	SetWindowLong(hWnd, GWL_STYLE, dwStyle & ~WS_OVERLAPPEDWINDOW);
	SetWindowPos(hWnd, HWND_TOP, g_windowPosX, g_windowPosY, g_windowWidth, g_windowHeight, SWP_NOOWNERZORDER | SWP_FRAMECHANGED);

	ShowWindow(hWnd, SW_SHOW);

	//setupandinitializeDirect3D
	if( !initD3D( hWnd ) )
		::MessageBoxA( hWnd, "Failed to initialize environment.", "Error", MB_OK | MB_ICONERROR );

	//enterthemainloop:

	MSG msg;

	while (TRUE)
	{
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		if (msg.message == WM_QUIT)
		{
			break;
		}

		render_frame();
	}

	//cleanupDirectXandCOM
	cleanD3D();

	return (int)msg.wParam;
}


//thisisthemainmessagehandlerfortheprogram
LRESULT CALLBACK WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	case WM_KEYDOWN:
	{
		switch (wParam)
		{
		case VK_ESCAPE:
			PostQuitMessage(0);
			return 0;
		case VK_LEFT:
		case 0x41: // a
			POSITION.x -= 10.0;
			return 0;
		case VK_RIGHT:
		case 0x44: // d
			POSITION.x += 10.0;
			return 0;
		case VK_UP:
			POSITION.y += 10.0;
			return 0;
		case VK_DOWN:
			POSITION.y -= 10.0;
			return 0;
		case 0x57: // w
			POSITION.z -= 10.0;
			return 0;
		case 0x53: // s
			POSITION.z += 10.0;
			return 0;
        case 0x31: // 1
            g_fWarping = max(g_fWarping - 0.1f, 0.f);
            break;
        case 0x32: // 2
            g_fWarping = min(g_fWarping + 0.1f, 1.f);
            break;
        case 0x33: // 3
            g_fBlending = max(g_fBlending - 0.1f, 0.f);
            break;
        case 0x34: // 4
            g_fBlending = min(g_fBlending + 0.1f, 1.f);
            break;
        case 0x35: // 5
            g_fBlackLevel = max(g_fBlackLevel - 0.1f, 0.f);
            break;
        case 0x36: // 6
            g_fBlackLevel = g_fBlackLevel + 0.1f;
            break;
		}
	}
	break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}


//thisfunctioninitializesandpreparesDirect3Dforuse
bool initD3D(HWND hWnd)
{
	d3d = Direct3DCreate9(D3D_SDK_VERSION);

	D3DPRESENT_PARAMETERS d3dpp;

	ZeroMemory(&d3dpp, sizeof(d3dpp));
	d3dpp.Windowed = TRUE;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.hDeviceWindow = hWnd;
	d3dpp.BackBufferFormat = D3DFMT_X8R8G8B8;
	d3dpp.BackBufferWidth = g_windowWidth;
	d3dpp.BackBufferHeight = g_windowHeight;

	//createadeviceclassusingthisinformationandtheinfofromthed3dppstuct
	d3d->CreateDevice(D3DADAPTER_DEFAULT,
		D3DDEVTYPE_HAL,
		hWnd,
		D3DCREATE_SOFTWARE_VERTEXPROCESSING,
		&d3dpp,
		&d3ddev);

	if( !init_graphics( hWnd ) ) //callthefunctiontoinitializethetriangle
		return false;
	d3ddev->SetRenderState(D3DRS_LIGHTING, FALSE); //turnoffthe3Dlighting
	d3ddev->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	dpResult r;
	r = dpCreateContextD3D9(&CTX, d3ddev, 2);
	if( r != dpNoError )
		return false;
    r = dpSetFlipWarpmeshVerticesYD3D9(CTX, false);
	if( r != dpNoError )
		return false;
	r = dpSetFlipWarpmeshTexcoordsVD3D9(CTX, false);
	if( r != dpNoError )
		return false;
	do{
		std::filesystem::path configPath( g_configfile );
		if( configPath.is_relative() ) {
			// try relative path
			//std::filesystem::path basePath = std::filesystem::current_path();
			r = dpLoadConfigurationFromFileD3D9( CTX, configPath.string().c_str() );
			if( r == dpNoError )
				break;

			// try module path
			std::wstring s( MAX_PATH, 0 );
			auto l = ::GetModuleFileNameW( reinterpret_cast< HMODULE >( &__ImageBase ), s.data(), MAX_PATH );
			s.erase( l );
			std::filesystem::path basePath = std::filesystem::path( s ).parent_path();
			r = dpLoadConfigurationFromFileD3D9( CTX, ( basePath / configPath ).string().c_str() );
			if( r == dpNoError )
				break;

			// last but not least try path of executable
			s.resize( MAX_PATH, 0 );
			l = ::GetModuleFileNameW( NULL, s.data(), MAX_PATH );
			s.erase( l );
			basePath = std::filesystem::path( s ).parent_path();
			r = dpLoadConfigurationFromFileD3D9( CTX, ( basePath / configPath ).string().c_str() );
		}
		else
			r = dpLoadConfigurationFromFileD3D9( CTX, configPath.string().c_str() );


		if( r != dpNoError )
			return false;
	} while( 0 );

	r = dpSetClippingPlanesD3D9(CTX, 1.0f, 100.0f);
	if( r != dpNoError )
		return false;
	return true;
}


//thisisthefunctionusedtorenderasingleframe
void render_frame(void)
{
	dpMatrix4x4 projection;
	dpVec3f orientation;
	dpVec3f eyepoint(500.0, 500.0, 0.0);

	dpSetActiveChannelD3D9(CTX, 0, d3ddev, g_windowWidth, g_windowHeight);
    dpSetCorrectionPassD3D9_1(CTX, dpWarpingPass, g_fWarping);
    dpSetCorrectionPassD3D9_1(CTX, dpBlendingPass, g_fBlending);
    dpSetCorrectionPassD3D9_1(CTX, dpBlackLevelPass, g_fBlackLevel);
	dpPreDrawD3D9(CTX, POSITION, &orientation, &projection, d3ddev);
	
	d3ddev->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(128, 128, 128), 0.0f, 0);
	d3ddev->BeginScene();

	render_skybox(orientation.x, -orientation.y, orientation.z);

	//selectwhichvertexformatweareusing
	//d3ddev->SetFVF(CUSTOMFVF);

	//SETUPTHEPIPELINE

	D3DXMATRIX matRotateY; //amatrixtostoretherotationinformation

	static float index = 0.0f; index += 0.01f; //anever-increasingfloatvalue

	//buildamatrixtorotatethemodelbasedontheincreasingfloatvalue
	D3DXMatrixRotationY(&matRotateY, index);

	//tellDirect3Daboutourmatrix
	//d3ddev->SetTransform(D3DTS_WORLD, &matRotateY);

	D3DXMATRIX matViewRot;
	D3DXMATRIX mat, matY, matP, matR;
	D3DXMatrixRotationY(&matY, D3DXToRadian(orientation.x));
	D3DXMatrixRotationX(&matP, D3DXToRadian(-orientation.y));
	D3DXMatrixRotationZ(&matR, D3DXToRadian(orientation.z));
	D3DXMatrixMultiply(&mat, &matP, &matR);
	D3DXMatrixMultiply(&matViewRot, &matY, &mat);

	D3DXMATRIX matView, matView2; //theviewtransformmatrix
	//D3DXMatrixRotationYawPitchRoll(&matViewRot, D3DXToRadian(orientation.x), D3DXToRadian(-orientation.y), D3DXToRadian(orientation.z));
	//D3DXMatrixIdentity(&matViewRot);
	D3DXMATRIX matViewTra;
	D3DXMatrixTranslation(&matViewTra, 0, 0, 0);
	D3DXMatrixMultiply(&matView, &matViewTra, &matViewRot);
	D3DXMatrixInverse(&matView, NULL, &matView);

	D3DXVECTOR3 pos{ 0.0f, 0.0f, 10.0f }, la{}, up{ 0.0f, 1.0f, 0.0f };
	D3DXMatrixLookAtRH( &matView2, &pos, &la, &up );

	d3ddev->SetTransform(D3DTS_VIEW, &matView); //settheviewtransformtomatView

	D3DXMATRIX matProjection; //theprojectiontransformmatrix
	D3DXMatrixPerspectiveFovRH(&matProjection,
		D3DXToRadian(60), //thehorizontalfieldofview
		(FLOAT)g_windowWidth / (FLOAT)g_windowHeight, //aspectratio
		1.0f, //thenearview-plane
		100.0f); //thefarview-plane
	D3DXMATRIX matProjection2(projection.matrix);

	d3ddev->SetTransform(D3DTS_PROJECTION, &matProjection2); //settheprojection

	////selectthevertexbuffertodisplay
	//d3ddev->SetStreamSource(0, v_buffer, 0, sizeof(CUSTOMVERTEX));

	////copythevertexbuffertothebackbuffer
	//d3ddev->DrawPrimitive(D3DPT_TRIANGLELIST, 0, 1);

	d3ddev->EndScene();

#if 1

	IDirect3DSurface9* pRenderTarget = NULL;
	//d3ddev->GetRenderTarget(0, &pRenderTarget);
	d3ddev->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &pRenderTarget);
	//D3DXSaveSurfaceToFileA("surface.bmp", D3DXIMAGE_FILEFORMAT::D3DXIFF_BMP, pRenderTarget, NULL, NULL);

	dpPostDrawD3D9_1(CTX, pRenderTarget, d3ddev);
	//dpPostDrawD3D9(CTX, skyboxtex[0], d3ddev);

	//dpMesh m;
	//dpGetWarpmeshD3D9(CTX, 0, &m);
	//dpSaveObj("warpmesh.obj", m);

	pRenderTarget->Release();

	char message[200];
	sprintf_s(message, "EYEPOINT: (%.2f,%.2f,%.2f)", POSITION.x, POSITION.y, POSITION.z);
	DrawMessage(font, 100, 100, 255, 255, 0, 0, message);

#endif
	d3ddev->Present(NULL, NULL, NULL, NULL);
}


//thisisthefunctionthatcleansupDirect3DandCOM
void cleanD3D(void)
{
	dpResult r;
	r = dpDestroyContextD3D9(CTX, d3ddev);

	v_buffer->Release(); //closeandreleasethevertexbuffer
	d3ddev->Release(); //closeandreleasethe3Ddevice
	d3d->Release(); //closeandreleaseDirect3D

	font->Release(); // delete the font
}


//thisisthefunctionthatputsthe3DmodelsintovideoRAM
bool init_graphics( HWND hWnd )
{
	//createtheverticesusingtheCUSTOMVERTEXstruct
	CUSTOMVERTEX vertices[] =
	{
		{ 3.0f, -3.0f, 0.0f, D3DCOLOR_XRGB(0, 0, 255), },
		{ 0.0f, 3.0f, 0.0f, D3DCOLOR_XRGB(0, 255, 0), },
		{ -3.0f, -3.0f, 0.0f, D3DCOLOR_XRGB(255, 0, 0), },
	};

	//createavertexbufferinterfacecalledv_buffer
	d3ddev->CreateVertexBuffer(3 * sizeof(CUSTOMVERTEX),
		0,
		CUSTOMFVF,
		D3DPOOL_MANAGED,
		&v_buffer,
		NULL);

	VOID* pVoid; //avoidpointer

	//lockv_bufferandloadtheverticesintoit
	v_buffer->Lock(0, 0, (void**)&pVoid, 0);
	memcpy(pVoid, vertices, sizeof(vertices));
	v_buffer->Unlock();

	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/F.png", &skyboxtex[0]);
	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/B.png", &skyboxtex[1]);
	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/L.png", &skyboxtex[2]);
	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/R.png", &skyboxtex[3]);
	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/bottom.png", &skyboxtex[4]);
	D3DXCreateTextureFromFileA(d3ddev, "data/cubemap/T.png", &skyboxtex[5]);
	if( !skyboxtex[0] )
	{
		::MessageBoxA( hWnd, "Could not find SkyBox textures.", "Error", MB_OK | MB_ICONERROR );
		return false;
	}

	D3DXCreateFont(d3ddev, 30, 0, FW_BOLD, 0, FALSE, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_DONTCARE, TEXT("Arial"), &font);
	return true;
}

void render_skybox(float heading, float pitch, float bank)
{
	d3ddev->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);

	float w = 10.0;
	float h = 10.0;
	float d = 10.0;
	HRESULT hr;

	SKYBOXVERTEX front[] =
	{
		{ -w / 2.0f, -h / 2.0f, -d / 2.0f, 0.0f, 1.0f },
		{  w / 2.0f, -h / 2.0f, -d / 2.0f, 1.0f, 1.0f },
		{ -w / 2.0f,  h / 2.0f, -d / 2.0f, 0.0f, 0.0f },
		{  w / 2.0f,  h / 2.0f, -d / 2.0f, 1.0f, 0.0f },
	};
	SKYBOXVERTEX back[] =
	{
		{  w / 2.0f, -h / 2.0f, d / 2.0f, 0.0f, 1.0f },
		{ -w / 2.0f, -h / 2.0f, d / 2.0f, 1.0f, 1.0f },
		{  w / 2.0f,  h / 2.0f, d / 2.0f, 0.0f, 0.0f },
		{ -w / 2.0f,  h / 2.0f, d / 2.0f, 1.0f, 0.0f },
	};
	SKYBOXVERTEX left[] =
	{
		{ -w / 2.0f, -h / 2.0f,  d / 2.0f, 0.0f, 1.0f },
		{ -w / 2.0f, -h / 2.0f, -d / 2.0f, 1.0f, 1.0f },
		{ -w / 2.0f,  h / 2.0f,  d / 2.0f, 0.0f, 0.0f },
		{ -w / 2.0f,  h / 2.0f, -d / 2.0f, 1.0f, 0.0f },
	};
	SKYBOXVERTEX right[] =
	{
		{ w / 2.0f, -h / 2.0f, -d / 2.0f, 0.0f, 1.0f },
		{ w / 2.0f, -h / 2.0f,  d / 2.0f, 1.0f, 1.0f },
		{ w / 2.0f,  h / 2.0f, -d / 2.0f, 0.0f, 0.0f },
		{ w / 2.0f,  h / 2.0f,  d / 2.0f, 1.0f, 0.0f },
	};
	SKYBOXVERTEX bottom[] =
	{
		{ -w / 2.0f, -h / 2.0f,  d / 2.0f, 0.0f, 1.0f },
		{  w / 2.0f, -h / 2.0f,  d / 2.0f, 1.0f, 1.0f },
		{ -w / 2.0f, -h / 2.0f, -d / 2.0f, 0.0f, 0.0f },
		{  w / 2.0f, -h / 2.0f, -d / 2.0f, 1.0f, 0.0f },
	};
	SKYBOXVERTEX top[] =
	{
		{ -w / 2.0f, h / 2.0f, -d / 2.0f, 0.0f, 1.0f },
		{  w / 2.0f, h / 2.0f, -d / 2.0f, 1.0f, 1.0f },
		{ -w / 2.0f, h / 2.0f,  d / 2.0f, 0.0f, 0.0f },
		{  w / 2.0f, h / 2.0f,  d / 2.0f, 1.0f, 0.0f },
	};

	D3DXMATRIX mat, mat2, matY, matP, matR;
	D3DXMatrixRotationY(&matY, D3DXToRadian(heading));
	D3DXMatrixRotationX(&matP, D3DXToRadian(pitch));
	D3DXMatrixRotationZ(&matR, D3DXToRadian(bank));
	D3DXMatrixMultiply(&mat2, &matP, &matR);
	D3DXMatrixMultiply(&mat, &matY, &mat2);
	//D3DXMatrixIdentity(&mat);
	//D3DXMatrixLookAtRH(&mat, &D3DXVECTOR3(0, 0, 0), &D3DXVECTOR3(1, 0, 1), &D3DXVECTOR3(0, 1, 0));
	//D3DXMatrixRotationYawPitchRoll(&mat, D3DXToRadian(heading), D3DXToRadian(pitch), D3DXToRadian(bank));
	d3ddev->SetTransform(D3DTS_VIEW, &mat);
	
	D3DXMatrixPerspectiveFovRH(&mat, D3DXToRadian(90.0f), 1.0f, 1.0f, 1000.0f);
	//d3ddev->SetTransform(D3DTS_PROJECTION, &mat);

	hr = d3ddev->SetVertexShader(NULL);
	hr = d3ddev->SetPixelShader(NULL);
	hr = d3ddev->SetVertexDeclaration(NULL);

	hr = d3ddev->SetFVF(SKYBOXFVF);
	hr = d3ddev->SetTexture(0, skyboxtex[0]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, front, sizeof(SKYBOXVERTEX));
	hr = d3ddev->SetTexture(0, skyboxtex[1]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, back, sizeof(SKYBOXVERTEX));
	hr = d3ddev->SetTexture(0, skyboxtex[2]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, left, sizeof(SKYBOXVERTEX));
	hr = d3ddev->SetTexture(0, skyboxtex[3]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, right, sizeof(SKYBOXVERTEX));
	hr = d3ddev->SetTexture(0, skyboxtex[4]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, bottom, sizeof(SKYBOXVERTEX));
	hr = d3ddev->SetTexture(0, skyboxtex[5]);
	hr = d3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, top, sizeof(SKYBOXVERTEX));

	d3ddev->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
}

bool DrawMessage(LPD3DXFONT font, unsigned int x, unsigned int y, int alpha, unsigned char r, unsigned char g, unsigned char b, LPCSTR Message)
{	// Create a colour for the text
	D3DCOLOR fontColor = D3DCOLOR_ARGB(alpha, r, g, b);
	RECT rct; //Font
	rct.left = x;
	rct.right = 1680;
	rct.top = y;
	rct.bottom = rct.top + 200;
	font->DrawTextA(NULL, Message, -1, &rct, 0, fontColor);
	return true;
}
