# Custom FinddpLib.cmake to locate dpLib SDK

# Define version
set(dpLib_VERSION_MAJOR 6)
set(dpLib_VERSION_MINOR 0)
set(dpLib_VERSION_PATCH 0)
set(dpLib_VERSION_SUFFIX )
set(dpLib_VERSION "${dpLib_VERSION_MAJOR}.${dpLib_VERSION_MINOR}.${dpLib_VERSION_PATCH}${dpLib_VERSION_SUFFIX}")

#the find cmake file resides in share folder
set(dpLib_INCLUDE_DIRS 
    "${CMAKE_CURRENT_LIST_DIR}/../include"
)
set(dpLib_LIBRARY_DIRS 
    "${CMAKE_CURRENT_LIST_DIR}/../lib"
)
if(WIN32)
    set(dpLib_LIBRARIES 
        "dpLib"
    )
else()
    set(dpLib_LIBRARIES 
        "libdpLib.so"
    )
endif()

# Mark dpLib as found if the include directory exists
message( STATUS "dpLib check ${dpLib_LIBRARY_DIRS}/${dpLib_LIBRARIES}")
find_library( dpLib_LIBRARY NAMES ${dpLib_LIBRARIES} PATHS ${dpLib_LIBRARY_DIRS} NO_DEFAULT_PATH )
if( dpLib_LIBRARY )
    set(dpLib_FOUND TRUE)
    message(STATUS "Found ${dpLib_LIBRARY} version ${dpLib_VERSION}")
    # Expose the required variables
    add_library( dpLib SHARED IMPORTED )
    set_target_properties(dpLib PROPERTIES
        INTERFACE_INCLUDE_DIRECTORIES ${dpLib_INCLUDE_DIRS}
        INTERFACE_LINK_DIRECTORIES ${dpLib_LIBRARY_DIRS}
        INTERFACE_LINK_LIBRARIES ${dpLib_LIBRARIES}
        IMPORTED_IMPLIB ${dpLib_LIBRARY}
        IMPORTED_LOCATION ${dpLib_LIBRARY}
    )
    set(dpLib_INCLUDE_DIRS ${dpLib_INCLUDE_DIRS} CACHE PATH "dpLib include directories")
    set(dpLib_LIBRARIES ${dpLib_LIBRARY_DIRS} CACHE FILEPATH "dpLib library")
    set(dpLib_LIBRARY_DIRS ${dpLib_LIBRARIES} CACHE FILEPATH "dpLib library directories")
    if(WIN32)
        set(dpLib_BINARIES "${CMAKE_CURRENT_LIST_DIR}/../bin/dpLib.dll" CACHE FILEPATH "dpLib binary")
    endif()
    mark_as_advanced(dpLib_INCLUDE_DIRS dpLib_LIBRARIES dpLib_LIBRARY_DIRS dpLib)
else()
    message(FATAL_ERROR "dpLib not found.")
endif()
